// This is the oracle. It compute f(S), i.e. the number of edges between S and V/S.
// This code calculate the number of calls to f and also average of output after each update.
#include<bits/stdc++.h>
#include "oracle.h"
using namespace std;
typedef long double ld;

const int maxn = 200;
const ld eps = 1e-8;
int N;
long long query_count;
ld a[maxn][maxn], fout_sum;

ld determinantOfMatrix(vector<vector<ld> > mat)
{
  ld num1, num2, det = 1, temp[200], total = 1;
  int index, n = mat.size();
  // loop for traversing the diagonal elements
  for (int i = 0; i < n; i++)
    {
      index = i; // initialize the index
 
      // finding the index which has non zero value
      while (index < n && abs(mat[index][i]) < eps)
        {
	  index++;
        }
      if (index == n) // if there is non zero element
        {
	  // the determinant of matrix as zero
	  continue;
        }
      if (index != i)
        {
	  // loop for swapping the diagonal element row and
	  // index row
	  for (int j = 0; j < n; j++)
            {
	      swap(mat[index][j], mat[i][j]);
            }
	  // determinant sign changes when we shift rows
	  // go through determinant properties
	  det = det * pow(-1, index - i);
        }
 
      // storing the values of diagonal row elements
      for (int j = 0; j < n; j++)
        {
	  temp[j] = mat[i][j];
        }
      // traversing every row below the diagonal element
      for (int j = i + 1; j < n; j++)
        {
	  num1 = temp[i]; // value of diagonal element
	  num2 = mat[j][i]; // value of next row element
 
	  // traversing every column of row
	  // and multiplying to every row
	  for (int k = 0; k < n; k++)
            {
	      // multiplying to make the diagonal
	      // element and next row element equal
	      mat[j][k]  = (num1 * mat[j][k]) - (num2 * temp[k]);
            }
	  total = total * num1; // Det(kA)=kDet(A);
        }
    }
 
  // multiplying the diagonal elements to get determinant
  for (int i = 0; i < n; i++)
    {
      det = det * mat[i][i];
    }
  return (det / total); // Det(kA)/k=Det(A);
}

// Calculate f(S) and increase query_count by 1
ld f(vector<int> S)
{
  query_count += 1;
  vector<vector<ld> > mat;
  mat.resize(S.size());
  for(int i = 0; i < S.size(); i ++)
    for(int j = 0; j < S.size(); j ++)
      mat[i].push_back(a[S[i] - 1][S[j] - 1]);
  return log2(determinantOfMatrix(mat) + 1);
}

int main(int argc, char** argv)
{
  int K = atoi(argv[1]);
  cin >> N;
  // Read kernel
  for(int i = 0; i < N; i ++)
    for(int j = 0; j < N; j ++)
      cin >> a[i][j];
  // Call init(k) to initialize algorithms  
  init(K);
  // Add or remove elements
  for(int i = 0; i < N; i ++)
    fout_sum += add_element(i + 1);
  //  print_selected_elements();
  for(int i = 0; i < N - 1; i ++)
    fout_sum += remove_element(i + 1);
  // Print average founded cut and total number of query call
  cout<< (ld) fout_sum / (2 * N - 1) << " " << query_count << endl; 
}
